package ru.yandex.crypta.lab.tables;

import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;

import ru.yandex.crypta.common.data.GenericTable;
import ru.yandex.crypta.lab.proto.SocdemThreshold;


public class SocdemThresholdsTable extends GenericTable<SocdemThreshold> {
    private static final Table<Record> TABLE = DSL.table("api_socdem_thresholds");

    private static final Field<String> SOCDEM = DSL.field(DSL.name(TABLE.getName(), "socdem"), String.class);
    private static final Field<String> SEGMENT = DSL.field(DSL.name(TABLE.getName(), "segment"), String.class);
    private static final Field<Double> THRESHOLD = DSL.field(DSL.name(TABLE.getName(), "threshold"), Double.class);

    public SocdemThresholdsTable(Configuration configuration) {
        super(configuration, SocdemThreshold.class);
    }

    @Override
    protected SocdemThreshold read(Record record) {
        return SocdemThreshold.newBuilder()
                .setSocdem(record.get(SOCDEM))
                .setSegment(record.get(SEGMENT))
                .setThreshold(record.get(THRESHOLD))
                .build();
    }

    @Override
    public Select<Record> selectQuery() {
        return dsl.selectFrom(TABLE);
    }

    public UpdateConditionStep<Record> updateQuery(SocdemThreshold socdemThreshold) {
        return dsl
                .update(TABLE)
                .set(THRESHOLD, socdemThreshold.getThreshold())
                .where(SOCDEM.eq(socdemThreshold.getSocdem()))
                .and(SEGMENT.eq(socdemThreshold.getSegment()));
    }

    public InsertSetMoreStep<Record> insertQuery(SocdemThreshold socdemThreshold) {
        return dsl
                .insertInto(TABLE)
                .set(SOCDEM, socdemThreshold.getSocdem())
                .set(SEGMENT, socdemThreshold.getSegment())
                .set(THRESHOLD, socdemThreshold.getThreshold());
    }


    public SelectConditionStep<Record> selectByIdQuery(SocdemThreshold socdemThreshold) {
        return dsl
                .selectFrom(TABLE)
                .where(SOCDEM.eq(socdemThreshold.getSocdem()))
                .and(SEGMENT.eq(socdemThreshold.getSegment()));
    }
}
