package ru.yandex.crypta.lab.tables;

import javax.ws.rs.core.SecurityContext;

import org.jooq.Configuration;

public class Tables {

    private final Configuration configuration;
    private final SecurityContext securityContext;

    public Tables(Configuration configuration, SecurityContext securityContext) {
        this.configuration = configuration;
        this.securityContext = securityContext;
    }

    public AudiencesTable audiences() {
        return new AudiencesTable(configuration, securityContext);
    }

    public ModelsTable models() {
        return new ModelsTable(configuration);
    }

    public SegmentsTable segments() {
        return new SegmentsTable(configuration, securityContext);
    }

    public SegmentExportsTable segmentExports() {
        return new SegmentExportsTable(configuration, securityContext);
    }

    public SegmentExportsTagsTable segmentExportsTags() {
        return new SegmentExportsTagsTable(configuration);
    }

    public ResponsiblesTable responsibles() {
        return new ResponsiblesTable(configuration);
    }

    public RulesTable rules() {
        return new RulesTable(configuration, securityContext);
    }

    public RulesConditionsTable rulesConditions() {
        return new RulesConditionsTable(configuration, securityContext);
    }

    public StakeholdersTable stakeholders() {
        return new StakeholdersTable(configuration);
    }

    public ModelSegmentRelationsTable modelSegmentRelations() {
        return new ModelSegmentRelationsTable(configuration);
    }

    public SocdemThresholdsTable socdemThresholds() {
        return new SocdemThresholdsTable(configuration);
    }

    public SamplesTable samples() {
        return new SamplesTable(configuration, securityContext);
    }

    public SampleViewsTable sampleViews() {
        return new SampleViewsTable(configuration, securityContext);
    }

    public KeywordsTable keywords() {
        return new KeywordsTable(configuration);
    }

    public SegmentIdsTable segmentIds() {
        return new SegmentIdsTable(configuration);
    }

    public SubsamplesTable subsamples() {
        return new SubsamplesTable(configuration);
    }

    public TrainingSamplesTable trainingSamples() { return new TrainingSamplesTable(configuration, securityContext); }

    public TrainingSamplesIndustriesTable trainingSamplesIndustries() { return new TrainingSamplesIndustriesTable(configuration); }

    public TrainableSegmentsTable trainableSegments() { return new TrainableSegmentsTable(configuration); }

    public MetricsTable metrics() { return new MetricsTable(configuration); }
}
