package ru.yandex.crypta.lab.tables;

import javax.ws.rs.core.SecurityContext;

import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lab.proto.AccessLevel;

public class TrainingSamplesAcl {

    public static Condition isAuthor(SecurityContext securityContext) {
        return TrainingSamplesTable.AUTHOR.eq(securityContext.getUserPrincipal().getName());
    }

    public static Condition isAdmin(SecurityContext securityContext) {
        return DSL.value(securityContext.isUserInRole(Roles.ADMIN) || securityContext.isUserInRole(Roles.Lab.ADMIN))
                .isTrue();
    }

    public static Condition isPublic() {
        return TrainingSamplesTable.ACCESS_LEVEL.eq(AccessLevel.PUBLIC.name());
    }

    public static Condition isShared() {
        return TrainingSamplesTable.ACCESS_LEVEL.eq(AccessLevel.SHARED.name());
    }

    public static Condition isAccessibleDirectlyBy(SecurityContext securityContext) {
        return isAuthor(securityContext).or(isPublic()).or(isShared()).or(isAdmin(securityContext));
    }

    public static Condition isListedFor(SecurityContext securityContext) {
        return isAuthor(securityContext).or(isPublic());
    }

    public static Condition isModifiableBy(SecurityContext securityContext) {
        return isAuthor(securityContext).or(isAdmin(securityContext));
    }
}
