package ru.yandex.crypta.lab.tables;

import org.jooq.Configuration;
import org.jooq.Delete;
import org.jooq.Field;
import org.jooq.Insert;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.DSL;

import ru.yandex.crypta.common.data.GenericTable;
import ru.yandex.crypta.lib.python.custom_ml.proto.TIndustry;


public class TrainingSamplesIndustriesTable extends GenericTable<TIndustry> {
    public static final Table<Record> TABLE = DSL.table("training_samples_industries");
    public static final Field<String> NAME = DSL.field(DSL.name(TABLE.getName(), "name"), String.class);
    private static final Field<String> MODEL_NAME = DSL.field(DSL.name(TABLE.getName(), "model_name"), String.class);
    public static final Field<String> AUTHOR = DSL.field(DSL.name(TABLE.getName(), "author"), String.class);
    public static final Field<String> OBJECTIVE = DSL.field(DSL.name(TABLE.getName(), "objective"), String.class);
    public static final Field<String> POSITIVE_CONVERSIONS = DSL.field(DSL.name(TABLE.getName(), "positive_conversions"), String.class);
    private static final Field<String> NEGATIVE_CONVERSIONS = DSL.field(DSL.name(TABLE.getName(), "negative_conversions"), String.class);

    public TrainingSamplesIndustriesTable(Configuration configuration) {
        super(configuration, TIndustry.class);
    }

    @Override
    protected TIndustry read(Record record) {
        TIndustry.Builder builder = TIndustry.newBuilder()
                .setName(record.get(NAME))
                .setModelName(record.get(MODEL_NAME))
                .setAuthor(record.get(AUTHOR))
                .setObjective(record.get(OBJECTIVE))
                .setPositiveConversions(record.get(POSITIVE_CONVERSIONS))
                .setNegativeConversions(record.get(NEGATIVE_CONVERSIONS));

        return builder.build();
    }

    @Override
    public Select<Record> selectQuery() {
        return dsl.selectFrom(TABLE);
    }

    public Select<Record> selectByIdQuery(String modelName) {
        return dsl.selectFrom(TABLE)
                .where(MODEL_NAME.eq(modelName));
    }

    public Insert<Record> insertQuery(TIndustry industry) {
        return dsl.insertInto(TABLE)
                .set(NAME, industry.getName())
                .set(MODEL_NAME, industry.getModelName())
                .set(AUTHOR, industry.getAuthor())
                .set(OBJECTIVE, industry.getObjective())
                .set(POSITIVE_CONVERSIONS, industry.getPositiveConversions())
                .set(NEGATIVE_CONVERSIONS, industry.getNegativeConversions());
    }

    public Delete<Record> deleteByIdQuery(String modelName) {
        return dsl.deleteFrom(TABLE)
                .where(MODEL_NAME.eq(modelName));
    }
}
