package ru.yandex.crypta.lab.utils;

import javax.inject.Inject;

import ru.yandex.crypta.clients.geobase.GeobaseClient;
import ru.yandex.crypta.common.Language;
import ru.yandex.geobase6.LinguisticsItem;

public class Geo {

    private static final String EMPTY = "";

    private final GeobaseClient geobase;

    @Inject
    public Geo(GeobaseClient geobase) {
        this.geobase = geobase;
    }

    public LinguisticsItem getLinguistics(long regionId, Language language) {
        try {
            return geobase.getLookup().getLinguistics((int) regionId, language.toString());
        } catch (Exception exception) {
            return new LinguisticsItem(EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
                    EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        }
    }

    public GeobaseClient getGeobase() {
        return geobase;
    }
}
