package ru.yandex.crypta.lab.utils;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GrpcRetries {
    public static Map<String, Object> buildConfig(Double maxAttemtps, Duration initialBackoff, Duration maxBackoff, Double backoffMultiplier) {
        var retryPolicy = Map.<String, Object>of(
            "maxAttempts", maxAttemtps,
            "initialBackoff", formatDuration(initialBackoff),
            "maxBackoff", formatDuration(maxBackoff),
            "backoffMultiplier", backoffMultiplier,
            "retryableStatusCodes", List.<Object>of("UNAVAILABLE")
        );

        var name = Map.<String, Object>of(
            "service", "",
            "method", ""
        );

        var methodConfig = Map.<String, Object>of(
            "name", Collections.<Object>singletonList(name),
            "retryPolicy", retryPolicy
        );

        return Map.<String, Object>of(
                "methodConfig", Collections.<Object>singletonList(methodConfig)
        );
    }

    private static String formatDuration(Duration d) {
        return String.format(Locale.ROOT, "%fs", d.getSeconds() + (d.getNano() / 1e9));
    }
}
