package ru.yandex.crypta.lab.utils;

import com.google.common.base.Preconditions;

import ru.yandex.crypta.lab.proto.Model;
import ru.yandex.crypta.lab.proto.Segment;
import ru.yandex.crypta.lab.tables.ModelSegmentRelationsTable;
import ru.yandex.crypta.lab.tables.Tables;

public class ModelSegmentRelations {

    private final Tables tables;

    public ModelSegmentRelations(Tables tables) {
        this.tables = tables;
    }

    public void store(Segment segment) {
        ModelSegmentRelationsTable relationsTable = tables.modelSegmentRelations();
        segment.getModelsList().forEach(relation -> {
            Preconditions.checkArgument(relation.getSegmentId().equals(segment.getId()));
            relationsTable.insertQuery(relation).execute();
        });
    }

    public void store(Model model) {
        ModelSegmentRelationsTable relationsTable = tables.modelSegmentRelations();
        model.getSegmentsList().forEach(relation -> {
            Preconditions.checkArgument(relation.getModelId().equals(model.getId()));
            relationsTable.insertQuery(relation).execute();
        });
    }

    public void clear(Segment segment) {
        String id = segment.getId();

        ModelSegmentRelationsTable relations = tables.modelSegmentRelations();

        relations.deleteBySegmentIdQuery(id).execute();
    }

    public void clear(Model model) {
        String id = model.getId();

        ModelSegmentRelationsTable relations = tables.modelSegmentRelations();

        relations.deleteByModelIdQuery(id).execute();
    }

}
