package ru.yandex.crypta.lab.utils;

import ru.yandex.inside.yt.kosher.cypress.YPath;

public class Paths {

    private final YPath root;

    public Paths(YPath root) {
        this.root = root;
    }

    public YPath sample(String id) {
        return samples().child(id);
    }

    public YPath training_sample(String id) {
        return training_samples().child(id);
    }

    public YPath model(String id) {
        return models().child(id);
    }

    public YPath models() {
        return root.child("models");
    }

    public YPath samples() {
        return root.child("samples");
    }

    public YPath training_samples() {
        return samples().child("training_samples");
    }

    public YPath sampleStats() {
        return root.child("SampleStats");
    }

    public YPath globalSampleStats() {
        return root.child("GlobalStatsCryptaId");
    }

    public YPath database() {
        return root.child("database");
    }

    public YPath customUserDataStats(String version) {
        return root.child("custom").child("user_data").child(version).child("UserDataStats");
    }
}
