package ru.yandex.crypta.lab.utils;

import java.util.Objects;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;

import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class Proto {

    public static void readField(Descriptors.FieldDescriptor field, YTreeMapNode entry, Message.Builder builder)
    {
        try {
            if (!Objects.equals(field.getType(), Descriptors.FieldDescriptor.Type.MESSAGE)) {
                return;
            }
            Descriptors.Descriptor descriptor = field.getMessageType();
            byte[] bytes = entry.getBytesO(field.getName()).orElse(null);
            if (!Objects.nonNull(bytes)) {
                return;
            }
            DynamicMessage message = DynamicMessage.parseFrom(descriptor, bytes);
            builder.setField(field, message);
        } catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Message> T readOrDefault(byte[] entry, Parser<T> parser, T defaultInstance) {
        try {
            if (Objects.isNull(entry)) {
                return defaultInstance;
            }
            return parser.parseFrom(entry);
        } catch (InvalidProtocolBufferException e) {
            return defaultInstance;
        }
    }

    public static <T extends Message> byte[] write(T message) {
        return message.toByteArray();
    }

}
