package ru.yandex.crypta.lab.utils;

import java.util.Map;

import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.lang.DefaultObject;

public class SchemaField extends DefaultObject {

    private final String name;
    private final String type;

    public SchemaField(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public static SchemaField fromMap(Map<String, YTreeNode> node) {
        String name = node.get("name").stringValue();
        String type = node.get("type").stringValue();
        return new SchemaField(name, type);
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

}
