package ru.yandex.crypta.lab.utils;

import java.util.List;

public class SegmentNode {
    private final String id;
    private final String parentId;
    private final List<SegmentNode> children;
    private final String name;

    public SegmentNode(String id, String parentId, List<SegmentNode> children, String name) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.children = children;
    }

    public String getId() {
        return id;
    }

    public String getParentId() {
        return parentId;
    }

    public List<SegmentNode> getChildren() {
        return children;
    }

    public String getName() {
        return name;
    }

    public void addChild(SegmentNode child) {
        children.add(child);
    }

    public SegmentNode insertNode(SegmentNode node) {
        if (id.equals(node.getParentId())) {
            addChild(node);
            return this;
        } else {
            if (children.size() == 0) {
                return node;
            } else {
                for (SegmentNode child : children) {
                    SegmentNode foundNode = child.insertNode(node);
                    if (foundNode.getId().equals(node.parentId)) {
                        return foundNode;
                    }
                }
            }
        }

        return node;
    }
}
