package ru.yandex.crypta.lab.yt;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.common.exception.IllegalOperationException;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeListNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

public class DefaultSampleServiceTest {

    private static YTreeMapNode field(String name, String type) {
        return YTree
                .mapBuilder()
                .key("name")
                .value(name)
                .key("type")
                .value(type)
                .buildMap();
    }

    private YTreeListNode schema(YTreeMapNode... fields) {
        YTreeBuilder listBuilder = YTree
                .listBuilder();
        for (YTreeMapNode field : fields) {
            listBuilder.value(field);
        }
        return listBuilder.buildList();
    }

    @Test(expected = IllegalOperationException.class)
    public void schemaValidationEmpty() {
        YTreeNode table = YTree.stringNode("table");
        table.getAttributes().put("schema", schema());
        assertNotNull(DefaultSampleService.validateSchemaAndObtainIdField(table, null, null));
    }

    @Test(expected = IllegalOperationException.class)
    public void schemaValidationWrongIdentifier() {
        YTreeNode table = YTree.stringNode("table");
        table.getAttributes().put("schema", schema(field("yuidz", "string")));
        assertNotNull(DefaultSampleService.validateSchemaAndObtainIdField(table, null, null));
    }

    @Test
    public void schemaValidation() {
        YTreeNode table = YTree.stringNode("table");
        table.getAttributes().put("schema", schema(
                field("yandexuid", "uint64"),
                field("othedr_identifier", "string")));
        assertNotNull(DefaultSampleService.validateSchemaAndObtainIdField(table, null, null));
    }

    @Test(expected = IllegalOperationException.class)
    public void sizeValidationEmpty() {
        MapF<String, YTreeNode> table = Cf.hashMap();
        table.put("row_count", YTree.integerNode(0));
        assertTrue(DefaultSampleService.validateSize(table));
    }

    @Test
    public void sizeValidation() {
        MapF<String, YTreeNode> table = Cf.hashMap();
        table.put("row_count", YTree.integerNode(1));
        assertTrue(DefaultSampleService.validateSize(table));
    }

}
