JAVA_LIBRARY(lab_api)

JDK_VERSION(17)

OWNER(
    g:crypta-api
)

PEERDIR(
    contrib/java/com/amazonaws/aws-java-sdk-s3
    contrib/java/com/google/code/gson/gson
    contrib/java/com/google/protobuf/protobuf-java-util
    contrib/java/commons-validator/commons-validator/1.7
    contrib/java/io/grpc/grpc-netty-shaded
    contrib/java/io/grpc/grpc-protobuf
    contrib/java/io/grpc/grpc-stub
    contrib/java/junit/junit
    contrib/java/org/antlr/antlr4-runtime/4.7.1
    contrib/java/org/apache/commons/commons-email
    contrib/java/org/flywaydb/flyway-core
    contrib/java/org/freemarker/freemarker
    contrib/java/org/openjfx/javafx-base-linux/11.0.1
    contrib/java/org/quartz-scheduler/quartz
    crypta/audience/api
    crypta/graph/soup/config/java/lib
    crypta/lab/proto
    crypta/lab/rule_estimator/services/api/proto
    crypta/lib/java/lemmer
    crypta/lib/java/mds
    crypta/lib/java/schedulers
    crypta/lib/java/word_rule
    crypta/lib/java/ws
    crypta/lib/java/yt
    crypta/lib/proto/config
    crypta/lib/proto/identifiers
    crypta/siberia/bin/common/describing/proto
    crypta/siberia/bin/common/proto
    crypta/siberia/bin/core/proto
    crypta/siberia/bin/custom_audience/common/proto
    crypta/siberia/bin/custom_audience/fast/grpc
    iceberg/inside-yt
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/java.inc)
INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/java_error_prone_checks.inc)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/org/apache/commons/commons-email/1.5
)

END()

IF (LINUX)
    RECURSE(
        src/test/java/ru/yandex/crypta/lab
    )
ENDIF()
