import logging

import library.python.resource as resource

from crypta.lib.python.bt.conf import conf
from crypta.lib.python.bt.commons import dates
from crypta.lib.python.bt.tasks import YQLTaskV1 as YQLTask
from crypta.lib.python.bt.workflow import IndependentTask, Parameter
from crypta.lib.python.bt.workflow.targets.table import HasAttribute


logger = logging.getLogger(__name__)


class PrepareApps(YQLTask, IndependentTask):
    day = Parameter(parse=dates.parse_day)

    @property
    def _attribute(self):
        return 'generate_date'

    @property
    def destination(self):
        return conf.paths.ids_storage.crypta_id.apps

    def targets(self):
        yield HasAttribute(
            self.yt,
            self.destination,
            self._attribute,
            self.day.isoformat(),
        )

    @property
    def query(self):
        return resource.find('/crypta/lab/crypta_id/apps.yql').format(
            app_metrica_month=conf.paths.ids_storage.device_id.app_metrica_month,
            vertices_no_multi_profile=conf.paths.graph.vertices_no_multi_profile,
            weights_output_table=conf.paths.ids_storage.crypta_id.apps_weights,
            output_table=self.destination,
        )

    def run(self, **kwargs):
        super(PrepareApps, self).run(**kwargs)
        self.yt.set_attribute(self.destination, self._attribute, self.day.isoformat())
