#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

import library.python.resource as resource

from crypta.lib.python.bt.conf import conf
from crypta.lib.python.bt.commons import dates
from crypta.lib.python.bt.tasks import YQLTaskV1 as YQLTask
from crypta.lib.python.bt.workflow import IndependentTask, Parameter
from crypta.lib.python.bt.workflow.targets.table import HasAttribute


logger = logging.getLogger(__name__)


class PrepareDevices(YQLTask, IndependentTask):
    day = Parameter(parse=dates.parse_day)

    @property
    def _attribute(self):
        return 'generate_date'

    @property
    def destination(self):
        return conf.paths.ids_storage.crypta_id.devices

    def targets(self):
        yield HasAttribute(
            self.yt,
            self.destination,
            self._attribute,
            self.day.isoformat(),
        )

    @property
    def query(self):
        return resource.find('/crypta/lab/crypta_id/devices.yql').format(
            yuid_with_all_info=conf.paths.ids_storage.yandexuid.yuid_with_all,
            yandexuid_cryptaid=conf.paths.matching.yandexuid_cryptaid,
            app_metrica=conf.paths.ids_storage.device_id.app_metrica_month,
            matching=conf.paths.graph.vertices_no_multi_profile,
            output_table=self.destination,
        )

    def run(self, **kwargs):
        super(PrepareDevices, self).run(**kwargs)
        self.yt.set_attribute(self.destination, self._attribute, self.day.isoformat())
