#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging

import crypta.lib.python.bt.commons.dates as dates
import crypta.lib.python.bt.workflow as workflow

from crypta.lab.lib.crypta_id.apps import PrepareApps
from crypta.lab.lib.crypta_id.devices import PrepareDevices
from crypta.lab.lib.crypta_id.regions import PrepareRegionsMonitoring

logger = logging.getLogger(__name__)


class MainTask(workflow.SinkTask):
    day = workflow.Parameter(parse=dates.parse_day)

    def requires(self):
        yield PrepareApps(day=self.day)
        yield PrepareDevices(day=self.day)
        yield PrepareRegionsMonitoring(day=self.day)
