import logging

from yt import wrapper

from crypta.lab.lib import tables
from crypta.lab.lib.crypta_id.apps import PrepareApps
from crypta.lab.lib.crypta_id.devices import PrepareDevices
from crypta.lab.lib.crypta_id.regions import PrepareRegions
from crypta.lab.lib.userdata import PrepareUserData
from crypta.lib.python.bt import (
    tasks,
    workflow,
)
from crypta.lib.python.bt.commons import dates
from crypta.lib.python.bt.conf import conf
from crypta.lib.python.bt.workflow.targets import table as table_targets


logger = logging.getLogger(__name__)


class PrepareCryptaIDUserData(PrepareUserData):
    day = workflow.Parameter(parse=dates.parse_day)

    @property
    def str_day(self):
        return self.day.strftime('%Y-%m-%d')

    KEYWORDS = [216, 217, 601, 602, 544, 546, 547, 549]

    def requires(self):
        yield PrepareApps(day=dates.yesterday())
        yield PrepareRegions(day=dates.yesterday())
        yield PrepareDevices(day=dates.yesterday())
        yield tasks.ExternalInputWithAttribute(
            yt_table=conf.paths.cryptaid_profiles_for_14days,
            attribute='generate_date',
            value=self.day,
        )
        yield tasks.ExternalInputWithAttribute(
            yt_table=conf.paths.vectors.crypta_id.monthly,
            attribute='generate_date',
            value=self.day,
        )

    def targets(self):
        yield table_targets.HasAttribute(
            self.yt, self.userdata, tables.UserData.Attributes.LAST_UPDATE_DATE, str(self.day)
        )
        yield table_targets.HasAttribute(
            self.yt, self.userdata_stats, tables.UserData.Attributes.LAST_UPDATE_DATE, str(self.day)
        )

    @property
    def userdata(self):
        return conf.paths.lab.data.crypta_id.userdata

    @property
    def userdata_stats(self):
        return conf.paths.lab.data.crypta_id.userdata_stats

    @property
    def userdata_daily(self):
        return conf.paths.lab.data.crypta_id.userdata_daily

    @property
    def id_type(self):
        return tables.UserData.Fields.CRYPTA_ID

    def run(self, **kwargs):
        cryptaid_regions = wrapper.TablePath(
            name=conf.paths.ids_storage.crypta_id.regions,
            columns=('main_region_city', 'main_region_country', 'crypta_id'),
        )

        apps = conf.paths.ids_storage.crypta_id.apps
        vectors = conf.paths.vectors.crypta_id.monthly
        profiles = conf.paths.cryptaid_profiles_for_14days
        devices = conf.paths.ids_storage.crypta_id.devices
        cids_words_weights = conf.paths.affinitives.crypta_id.words
        cids_hosts_weights = conf.paths.affinitives.crypta_id.hosts

        sources = [vectors, cryptaid_regions, profiles, devices, cids_words_weights, cids_hosts_weights, apps]

        mapper_files = [self.yt.TablePath(
            conf.paths.ids_storage.crypta_id.apps_weights,
            attributes={
                'format': 'yson',
                'file_name': 'apps_weights',
            }
        )]

        self.run_map_reduce(sources, vectors, profiles, mapper_files=mapper_files)
        self.store_daily()
        self.postprocess_tables(table_to_process=tables.UserData)
