#pragma once

#include <crypta/lab/lib/native/utils.h>
#include <crypta/lab/proto/other.pb.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>

using namespace NYT;
using namespace NLab;

class TRenameIdentifierMapper: public TStateful<NLab::TRenameIdentifierMapperState, IMapper<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TRenameIdentifierMapper()
        : TStateful()
    {
    }
    TRenameIdentifierMapper(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TGenericJoinReducer: public TStateful<NLab::TJoinOptions, IReducer<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TGenericJoinReducer()
        : TStateful()
    {
    }

    TGenericJoinReducer(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TIdentityMapper: public IMapper<TTableReader<TNode>, TTableWriter<TNode>> {
public:
    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TUniqueReducer: public IReducer<TTableReader<TNode>, TTableWriter<TNode>> {
public:
    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TSubsamplesJoinReducer: public TStateful<NLab::TGroupNameState, IReducer<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TSubsamplesJoinReducer()
        : TStateful()
    {
    }

    TSubsamplesJoinReducer(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }
    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TValidateMapper: public TStateful<NLab::TSourceDestinationState, IMapper<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TValidateMapper()
        : TStateful()
    {
    }

    TValidateMapper(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TAddGroupingKey: public TStateful<NLab::TRenameIdentifierMapperState, IMapper<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TAddGroupingKey()
        : TStateful()
    {
    }
    TAddGroupingKey(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};
