#include "encoded_user_data.h"

#include <crypta/lib/proto/user_data/token_dict_item.pb.h>

using namespace NLab;
using namespace NLab::NEncodedUserData;

namespace {
    struct TStringToWeightedIdInserter {
        using TDict = TTokenToWeightedIdDict;

        static bool Insert(const TTokenDictItem& item, TDict& dict) {
            return dict.emplace(item.GetToken(), TWeightedId{.Id = item.GetId(), .Weight = static_cast<float>(item.GetWeight())}).second;
        }
    };

    struct TStringToIdInserter {
        using TDict = TTokenToIdDict;

        static bool Insert(const TTokenDictItem& item, TDict& dict) {
            return dict.emplace(item.GetToken(), item.GetId()).second;
        }
    };

    template<typename TInserter>
    typename TInserter::TDict ReadTokenDictImpl(NYT::ITransactionPtr tx, const TString& dictTable) {
        typename TInserter::TDict result;

        if (tx->Exists(dictTable)) {
            for (auto reader = tx->CreateTableReader<TTokenDictItem>(dictTable); reader->IsValid(); reader->Next()) {
                const auto& row = reader->GetRow();
                Y_ENSURE(TInserter::Insert(row, result), "Tokens must be unique, but they are not (token=" << row.GetToken() << ")");
            }
        }

        return result;
    }
}

TTokenToWeightedIdDict NEncodedUserData::ReadStringToWeightedIdDict(NYT::ITransactionPtr tx, const TString& dictTable) {
    return ReadTokenDictImpl<TStringToWeightedIdInserter>(tx, dictTable);
}

TTokenToIdDict NEncodedUserData::ReadStringToIdDict(NYT::ITransactionPtr tx, const TString& dictTable) {
    return ReadTokenDictImpl<TStringToIdInserter>(tx, dictTable);
}
