#pragma once

#include <mapreduce/yt/interface/client.h>

namespace NLab::NEncodedUserData {
    using TDictId = ui32;

    struct TWeightedId {
        TDictId Id = 0;
        float Weight = 0;
    };

    struct TWeightedToken {
        TString Token;
        float Weight = 0;
    };

    using TTokenToIdDict = THashMap<TString, TDictId>;
    using TTokenToWeightedIdDict = THashMap<TString, TWeightedId>;
    using TIdToWeightedTokenDict = THashMap<TDictId, TWeightedToken>;

    TTokenToIdDict ReadStringToIdDict(NYT::ITransactionPtr tx, const TString& dictTable);
    TTokenToWeightedIdDict ReadStringToWeightedIdDict(NYT::ITransactionPtr tx, const TString& dictTable);
}
