#pragma once

#include <crypta/lab/lib/native/segments_user_data_stats_aggregator.h>
#include <crypta/lab/lib/native/user_data_stats_aggregator.h>
#include <crypta/lab/lib/native/utils.h>
#include <crypta/lab/proto/other.pb.h>
#include <crypta/lib/native/dates/dates.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>

#include <util/generic/set.h>
#include <unordered_set>


namespace NLab {
    struct TId {
		enum class EIdType {
			Yandexuid,
			CryptaId,
		};

		ui64 Id = 0;
		EIdType Type;
	};

    class TExtractUserData: public TStateful<NLab::TExtractUserDataState, NYT::IMapper<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NLab::TUserData>>> {
    public:

        TExtractUserData() = default;
        explicit TExtractUserData(const TBuffer& buffer);

        static TMaybe<ui64> GetExactCity(const NYT::TNode& row);
        static TCity GetCity(const NYT::TNode& row);
        static TCountry GetCountry(const NYT::TNode& row);
        static TString GetDeviceTypeFromUa(const TString& uaProfile);
        static TDevice GetDevice(const NYT::TNode& row);
        static bool HasActiveIp(const NYT::TNode& row);
        static void AddSegments(const NYT::TNode& row, const TExtractUserDataState::TProfilesLogState::TFields& fields, ui64 keyword, TUserData* userData);
        static TGender GetGender(const NYT::TNode& row);
        static TAge GetAge(const NYT::TNode& row);
        static TIncome GetIncome(const NYT::TNode& row);
        static TTokens GetAffinitiveSites(const NYT::TNode& row);
        static TTokens GetTopCommonSites(const NYT::TNode& row);

        static bool ProcessMonthlyVectors(const NYT::TNode& row, TUserData& userData, time_t oldestActiveTimestamp);
        static bool ProcessWords(const NYT::TNode& row, TUserData& userData);
        static bool ProcessHosts(const NYT::TNode& row, TUserData& userData);
        static bool ProcessRegionsAndDevice(const NYT::TNode& row, TUserData& userData, const TId::EIdType& Type);
        static bool ProcessDeviceCryptaID(const NYT::TNode& row, TUserData& userData);
        static bool ProcessProfilesLog(const NYT::TNode& row, TUserData& userData, const TExtractUserDataState::TProfilesLogState& state);
        static bool ProcessYuidCid(const NYT::TNode& row, TUserData& userData);
        bool ProcessApps(const NYT::TNode& row, TUserData& userData);

        void Start(TWriter*) override;
        void Do(NYT::TTableReader<NYT::TNode>* input, NYT::TTableWriter<NLab::TUserData>* output) override;

    public:
        TMap<TString, ui64> AppsWeights;

    private:
        static const std::unordered_set<ui64> PROBABILISTIC_KEYWORDS;
    };
}
