#pragma once

#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lab/lib/native/utils.h>
#include <crypta/lab/proto/other.pb.h>
#include <crypta/lib/native/state/common.h>

#include <util/generic/map.h>

using namespace NYT;

class TComputeMatchingIdMapper: public TStateful<NLab::TSourceDestinationState, IMapper<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TComputeMatchingIdMapper()
        : TStateful()
    {
    }
    TComputeMatchingIdMapper(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TJoinCryptaIDReducer: public TStateful<NLab::TSourceDestinationState, IReducer<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TJoinCryptaIDReducer()
        : TStateful()
    {
    }
    TJoinCryptaIDReducer(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TJoinIdentifiersReducer: public TStateful<NLab::TSourceDestinationState, IReducer<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TJoinIdentifiersReducer()
        : TStateful()
    {
    }
    TJoinIdentifiersReducer(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};

class TJoinIdentifiersStatisticReducer: public TStateful<NLab::TSourceDestinationState, IReducer<TTableReader<TNode>, TTableWriter<TNode>>> {
public:
    TJoinIdentifiersStatisticReducer()
        : TStateful()
    {
    }
    TJoinIdentifiersStatisticReducer(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Do(TTableReader<TNode>* input, TTableWriter<TNode>* output) override;
};
