#pragma once

#include <crypta/lib/python/native_yt/cpp/registrar.h>

#include <crypta/lab/lib/native/lookalike.h>
#include <crypta/lab/lib/native/describe.h>
#include <crypta/lab/lib/native/matching.h>
#include <crypta/lab/lib/native/stats.h>
#include <crypta/lab/lib/native/extract_userdata.h>

CYT_REGISTER_MAPPER(TLookalikeMapper);
CYT_REGISTER_REDUCER(TLookalikeReducer);
CYT_REGISTER_REDUCER(TLookalikeJoiner);

CYT_REGISTER_MAPPER(TRenameIdentifierMapper);
CYT_REGISTER_MAPPER(TAddGroupingKey);
CYT_REGISTER_MAPPER(TComputeMatchingIdMapper);
CYT_REGISTER_REDUCER(TGenericJoinReducer);
CYT_REGISTER_REDUCER(TJoinCryptaIDReducer);
CYT_REGISTER_REDUCER(TJoinIdentifiersReducer);
CYT_REGISTER_REDUCER(TJoinIdentifiersStatisticReducer);

CYT_REGISTER_MAPREDUCER(TIdentityMapper, TUniqueReducer);

CYT_REGISTER_MAPPER(TValidateMapper);

CYT_REGISTER_MAPREDUCER_WITH_COMBINER(TTransformUserDataToUserDataStats, TMergeUserDataStats, TMergeUserDataStats);

CYT_REGISTER_REDUCER(TPredictReducer);
CYT_REGISTER_MAPPER(TPredictMapper);

CYT_REGISTER_MAPREDUCER(NLab::TExtractUserData, TMergeUserData);

CYT_REGISTER_REDUCER(TSubsamplesJoinReducer);
