#pragma once

#include "user_data_stats_aggregator.h"

#include <crypta/lib/native/state/common.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>

#include <library/cpp/bloom_filter/bloomfilter.h>

#include <util/generic/hash.h>
#include <util/generic/set.h>

namespace NLab {
    class TSegmentsUserDataStatsAggregator {
    public:
        explicit TSegmentsUserDataStatsAggregator(const NNativeYT::TProtoState<TUserDataStatsOptions>& state);

        void Start(NYT::TTableWriter<TUserDataStats>*, const NNativeYT::TProtoState<TUserDataStatsOptions>& state);
        void Emit(NYT::TTableWriter<TUserDataStats>* output);
        void EmitIfLarge(NYT::TTableWriter<TUserDataStats>* output);
        void Finish(NYT::TTableWriter<TUserDataStats>* output);
        bool FillMetaFromOptions(TUserDataStats& userDataStats, const TUserData& userData);
        bool Skip(const TString& identifier);

        NLab::TUserDataStatsAggregator<>& GetOrCreateSegmentAggr(const TString& segmentID);

        void ConvertUserDataToUserDataStats(NLab::TUserDataStats& userDataStats, const NLab::TUserData& userData, bool skip = false);

        void UpdateWith(const NLab::TUserDataStats& userDataStats);

    private:
        NNativeYT::TProtoState<TUserDataStatsOptions> State;
        THashMap<TString, NLab::TUserDataStatsAggregator<>> StatsAggregatorsBySegment;
        TMaybe<TSet<NLab::TSegment>> UsedStrataSegments;

        const ui64 MAX_SEGMENTS_IN_STATS = 250;

        bool IgnoreStrataSegment(const NLab::TSegment& segment);

        void GetStats(TUserDataStats& userDataStats, const NLab::TUserData& userData);

        static TUserDataStats GetEmptyStats();

        static TNormalSufficientStatistic ToStatistic(const TVectorType& vector);

        static void FillTokensStats(TUserDataStats::TTokensStats& stats, const TTokens& tokens);
        static void FillTokensStatsEncoded(TUserDataStats::TTokensStatsEncoded& stats, const ::google::protobuf::RepeatedField<ui32>& tokens);

        TFilterIdentifier SkipFilter;
    };
}
