#include "stats.h"

#include <crypta/lib/native/sampler/rest_sampler.h>

#include <util/string/ascii.h>
#include <util/string/cast.h>

#include <iostream>
#include <tuple>
#include <utility>

using namespace NLab;
using namespace NYT;


void TTransformUserDataToUserDataStats::Do(TTableReader<TUserData>* input, TTableWriter<TUserDataStats>* output) {
    TUserDataStats userDataStats;

    for (ui64 rowCount = 0; input->IsValid(); input->Next(), ++rowCount) {
        const auto& userData = input->GetRow();
        bool skip = Aggregator.Skip(userData.GetYandexuid());

        Aggregator.ConvertUserDataToUserDataStats(userDataStats, userData, skip);

        Aggregator.FillMetaFromOptions(userDataStats, userData);
        if (userDataStats.GetFilter().GetOptions().GetCapacity()) {
            output->AddRow(userDataStats);
        } else {
            Aggregator.UpdateWith(userDataStats);
        }

        if (userData.GetGroupID() && State->GetFlags().GetDuplicateWithoutGroupID()) {
            userDataStats.ClearGroupID();
            Aggregator.UpdateWith(userDataStats);
        }
        Aggregator.EmitIfLarge(output);
    }
    Aggregator.Emit(output);
}

void TTransformUserDataToUserDataStats::Start(TTableWriter<TUserDataStats>* output) {
    Aggregator.Start(output, State);
}

void TTransformUserDataToUserDataStats::Finish(TTableWriter<TUserDataStats>* output) {
    Aggregator.Finish(output);
}


void TMergeUserDataStats::Do(TTableReader<TUserDataStats>* input, TTableWriter<TUserDataStats>* output) {
    TUserDataStats userDataStats;
    TUserDataStatsAggregator<> aggregator;

    for (bool firstRow = true; input->IsValid(); input->Next()) {
        const auto& row = input->GetRow();
        if (firstRow) {
            firstRow = false;
            userDataStats.SetGroupID(row.GetGroupID());
        }
        aggregator.UpdateWith(row);
    }
    aggregator.MergeInto(userDataStats);
    output->AddRow(userDataStats);
}

void TMergeUserData::Do(TTableReader<TUserData>* input, TTableWriter<TUserData>* output) {
    TUserData userData;
    for (; input->IsValid(); input->Next()) {
        TUserData row = input->GetRow();
        userData.MergeFrom(row);
    }
    if (!userData.GetCryptaID().empty()) {
        userData.MutableAttributes()->SetHasCryptaID(true);
    }
    if (userData.HasVectors()) {
        output->AddRow(userData);
    }
}
