#pragma once

#include "segments_user_data_stats_aggregator.h"
#include "user_data_stats_aggregator.h"

#include <crypta/lab/lib/native/utils.h>
#include <crypta/lab/proto/other.pb.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/native/dates/dates.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>

#include <util/generic/set.h>

bool IgnoreStrataSegment(const TMaybe<TSet<NLab::TSegment>>& usedStrataSegments, const NLab::TSegment& segment);


class TMergeUserDataStats: public NYT::IReducer<NYT::TTableReader<NLab::TUserDataStats>, NYT::TTableWriter<NLab::TUserDataStats>> {
public:
    void Do(NYT::TTableReader<NLab::TUserDataStats>* input, NYT::TTableWriter<NLab::TUserDataStats>* output) override;
};

class TMergeUserData: public NYT::IReducer<NYT::TTableReader<NLab::TUserData>, NYT::TTableWriter<NLab::TUserData>> {
public:
    void Do(NYT::TTableReader<NLab::TUserData>* input, NYT::TTableWriter<NLab::TUserData>* output) override;
};


class TTransformUserDataToUserDataStats: public TStateful<NLab::TUserDataStatsOptions, NYT::IMapper<NYT::TTableReader<NLab::TUserData>, NYT::TTableWriter<NLab::TUserDataStats>>> {
public:
    TTransformUserDataToUserDataStats()
        : TStateful(), Aggregator(State)
    {
    }
    TTransformUserDataToUserDataStats(const TBuffer& buffer)
        : TStateful(buffer), Aggregator(State)
    {
    }

    void Start(NYT::TTableWriter<NLab::TUserDataStats>*) override;
    void Do(NYT::TTableReader<NLab::TUserData>* input, NYT::TTableWriter<NLab::TUserDataStats>* output) override;
    void Finish(NYT::TTableWriter<NLab::TUserDataStats>* output) override;

private:
    NLab::TSegmentsUserDataStatsAggregator Aggregator;
};
