#include "strata_aggregator.h"

using namespace NLab;

void TStrataAggregator::UpdateWith(const TUserDataStats::TStratumStats& stratumStats) {
    const auto& stataStatsList = stratumStats.GetStrata();

    for (const auto& strataStats : stataStatsList) {
        auto& aggregators = Aggregators[strataStats.GetStrata()];

        for (const auto& segmentCount : strataStats.GetSegment()) {
            aggregators.SegmentsAggregator.UpdateWith(segmentCount);
        }
        for (const auto& ageCount : strataStats.GetAge()) {
            aggregators.AgeAggregator.UpdateWith(ageCount);
        }
        for (const auto& genderCount : strataStats.GetGender()) {
            aggregators.GenderAggregator.UpdateWith(genderCount);
        }
        for (const auto& incomeCount : strataStats.GetIncome()) {
            aggregators.IncomeAggregator.UpdateWith(incomeCount);
        }

        aggregators.Count += strataStats.GetCount();
    }
}

void TStrataAggregator::MergeInto(TUserDataStats::TStratumStats* stratumStats) {
    stratumStats->Clear();
    for (auto& [strata, aggregators] : Aggregators) {
        auto* strataCount = stratumStats->AddStrata();
        strataCount->MutableStrata()->CopyFrom(strata);

        aggregators.SegmentsAggregator.MergeInto(*strataCount);
        aggregators.AgeAggregator.MergeInto(*strataCount);
        aggregators.GenderAggregator.MergeInto(*strataCount);
        aggregators.IncomeAggregator.MergeInto(*strataCount);

        strataCount->SetCount(aggregators.Count);
    }
}
