#pragma once

#include "counted_aggregators.h"

#include <crypta/lib/proto/user_data/user_data_stats.pb.h>

#include <util/generic/map.h>

namespace {
    auto ConvertToTuple(const NLab::TStrata& strata) {
        return std::make_tuple(strata.GetHasCryptaID(), strata.GetDevice(), strata.GetCountry(), strata.GetCity());
    }
}

template <>
struct TLess<NLab::TStrata> {
    bool operator()(const NLab::TStrata& lhs, const NLab::TStrata& rhs) const {
        return ConvertToTuple(lhs) < ConvertToTuple(rhs);
    }
};

namespace NLab {
    class TStrataAggregator {
    public:
        void UpdateWith(const TUserDataStats::TStratumStats& stratumStats);
        void MergeInto(TUserDataStats::TStratumStats* stratumStats);

    private:
        struct TAggregators {
            TSegmentsAggregator SegmentsAggregator;
            TAgeAggregator AgeAggregator;
            TGenderAggregator GenderAggregator;
            TIncomeAggregator IncomeAggregator;
            size_t Count = 0;
        };

        TMap<TStrata, TAggregators> Aggregators;
    };
}
