#include "user_data_stats_aggregator.h"

using namespace NLab;
using namespace NLab::NEncodedUserData;

bool TDefaultAffinitiesOptions::HasAffinities(const TUserDataStats& userDataStats) {
    return userDataStats.HasAffinities();
}

const TDefaultAffinitiesOptions::TProtoAffinities& TDefaultAffinitiesOptions::GetAffinities(const TUserDataStats& userDataStats) {
    return userDataStats.GetAffinities();
}

TDefaultAffinitiesOptions::TProtoAffinities* TDefaultAffinitiesOptions::MutableAffinities(TUserDataStats& userDataStats) {
    return userDataStats.MutableAffinities();
}

void TDefaultAffinitiesOptions::UpdateAffinitiesWithTokensStats(TDefaultAffinitiesOptions::TTokensMap& tokensMap, const TDefaultAffinitiesOptions::TProtoTokensStats& tokensStats) {
    for (const auto& item : tokensStats.GetToken()) {
        auto& token = tokensMap[item.GetToken()];
        token.Weight += item.GetWeight();
        token.Count += item.GetCount();
    }
}

void TDefaultAffinitiesOptions::UpdateAffinitiesWithTokensStatsWoAggregation(TDefaultAffinitiesOptions::TTokensMap& tokensMap, const TDefaultAffinitiesOptions::TProtoTokensStats& tokensStats) {
    for (const auto& item : tokensStats.GetToken()) {
        tokensMap.insert({
             item.GetToken(),
             {.Weight = item.GetWeight(), .Count = item.GetCount()}
        });
    }
}

float TDefaultAffinitiesOptions::GetScore(TDefaultAffinitiesOptions::TTokensMap::const_reference kv, const TIdToWeightedTokenDict*) {
    return kv.second.Weight;
}

ui64 TDefaultAffinitiesOptions::GetCount(TTokensMap::const_reference kv) {
    return kv.second.Count;
}

void TDefaultAffinitiesOptions::FillTokensStats(TTokenStats* protoToken, TDefaultAffinitiesOptions::TTokensMap::const_reference kv) {
    protoToken->SetToken(kv.first);
    protoToken->SetWeight(kv.second.Weight);
    protoToken->SetCount(kv.second.Count);
}

bool TAffinitiesEncodedOptions::HasAffinities(const TUserDataStats& userDataStats) {
    return userDataStats.HasAffinitiesEncoded();
}

const TAffinitiesEncodedOptions::TProtoAffinities& TAffinitiesEncodedOptions::GetAffinities(const TUserDataStats& userDataStats) {
    return userDataStats.GetAffinitiesEncoded();
}

TAffinitiesEncodedOptions::TProtoAffinities* TAffinitiesEncodedOptions::MutableAffinities(TUserDataStats& userDataStats) {
    return userDataStats.MutableAffinitiesEncoded();
}

void TAffinitiesEncodedOptions::UpdateAffinitiesWithTokensStats(TAffinitiesEncodedOptions::TTokensMap& tokensMap, const TAffinitiesEncodedOptions::TProtoTokensStats& tokensStats) {
    for (const auto& item : tokensStats.GetToken()) {
        tokensMap[item.GetId()] += item.GetCount();
    }
}

void TAffinitiesEncodedOptions::UpdateAffinitiesWithTokensStatsWoAggregation(TAffinitiesEncodedOptions::TTokensMap& tokensMap, const TAffinitiesEncodedOptions::TProtoTokensStats& tokensStats) {
    for (const auto& item : tokensStats.GetToken()) {
        tokensMap.insert({item.GetId(), item.GetCount()});
    }
}

float TAffinitiesEncodedOptions::GetScore(TAffinitiesEncodedOptions::TTokensMap::const_reference kv, const TIdToWeightedTokenDict* dict) {
    Y_ENSURE(dict != nullptr, "Token dict is nullptr");
    return GetCount(kv) * dict->at(kv.first).Weight;
}

ui64 TAffinitiesEncodedOptions::GetCount(TTokensMap::const_reference kv) {
    return kv.second;
}

void TAffinitiesEncodedOptions::FillTokensStats(TTokenStats* protoToken, TAffinitiesEncodedOptions::TTokensMap::const_reference kv) {
    protoToken->SetId(kv.first);
    protoToken->SetCount(kv.second);
}
