#include "user_data_stats_decoder.h"

using namespace NLab;
using namespace NLab::NEncodedUserData;

namespace {
    void FillAffinities(TUserDataStats::TTokensStats* tokensStats, const TUserDataStats::TTokensStatsEncoded& tokensStatsEncoded, const TIdToWeightedTokenDict& dict) {
        tokensStats->SetTokensCount(tokensStatsEncoded.GetTokensCount());
        tokensStats->SetUsersCount(tokensStatsEncoded.GetUsersCount());

        for (const auto& tokenStatsEncoded : tokensStatsEncoded.GetToken()) {
            const auto& tokenInfo = dict.at(tokenStatsEncoded.GetId());
            auto* tokenStats = tokensStats->AddToken();

            *tokenStats->MutableToken() = tokenInfo.Token;
            tokenStats->SetCount(tokenStatsEncoded.GetCount());
            tokenStats->SetWeight(tokenInfo.Weight * tokenStatsEncoded.GetCount());
        }
    }
}

void NUserDataStatsDecoder::Decode(TUserDataStats& userDataStats, const TIdToWeightedTokenDict& words, const TIdToWeightedTokenDict& hosts, const TIdToWeightedTokenDict& apps) {
    TUserDataStats::TAffinitiveStatsEncoded affinitiesEncoded;
    affinitiesEncoded.Swap(userDataStats.MutableAffinitiesEncoded());

    auto* affinities = userDataStats.MutableAffinities();
    FillAffinities(affinities->MutableWords(), affinitiesEncoded.GetWords(), words);
    FillAffinities(affinities->MutableHosts(), affinitiesEncoded.GetHosts(), hosts);
    FillAffinities(affinities->MutableApps(), affinitiesEncoded.GetApps(), apps);
}
