#include <google/protobuf/util/message_differencer.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/unittest/registar.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>
#include <mapreduce/yt/util/ypath_join.h>


#include <crypta/lab/lib/native/strata_aggregator.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/lib/native/yaml/yaml2proto.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>

using namespace NLab;
using namespace NYT;
using namespace NYT::NTesting;

Y_UNIT_TEST_SUITE(TStrataAggregator) {

    Y_UNIT_TEST(OneUserDataStatsTest) {
        const TString userDataStatsYaml = "stratum:\n"
                                          "  strata:\n"
                                          "  - strata:\n"
                                          "      device: desktop\n"
                                          "      country: russia\n"
                                          "      city: moscow\n"
                                          "      has_crypta_i_d: true\n"
                                          "    segment:\n"
                                          "    - segment:\n"
                                          "        keyword: 1\n"
                                          "        i_d: 2\n"
                                          "      count: 1\n"
                                          "    age:\n"
                                          "    - age: from_0_to_17\n"
                                          "      count: 1\n"
                                          "    gender:\n"
                                          "    - gender: male\n"
                                          "      count: 1\n"
                                          "    income:\n"
                                          "    - income: income_b1\n"
                                          "      count: 1\n"
                                          "    count: 1\n";

        const TString refYaml = "stratum:\n"
                                "  strata:\n"
                                "  - strata:\n"
                                "      device: desktop\n"
                                "      country: russia\n"
                                "      city: moscow\n"
                                "      has_crypta_i_d: true\n"
                                "    segment:\n"
                                "    - segment:\n"
                                "        keyword: 1\n"
                                "        i_d: 2\n"
                                "      count: 1\n"
                                "    age:\n"
                                "    - age: from_0_to_17\n"
                                "      count: 1\n"
                                "    gender:\n"
                                "    - gender: male\n"
                                "      count: 1\n"
                                "    income:\n"
                                "    - income: income_b1\n"
                                "      count: 1\n"
                                "    count: 1\n";

        const auto& userDataStats = NCrypta::Yaml2Proto<TUserDataStats>(userDataStatsYaml);
        const auto& ref = NCrypta::Yaml2Proto<TUserDataStats>(refYaml);


        TStrataAggregator strataAggregator;
        TUserDataStats result;

        strataAggregator.UpdateWith(userDataStats.GetStratum());
        strataAggregator.MergeInto(result.MutableStratum());

        Cerr << NCrypta::NProtoSerializer::ToJson(result) << Endl;
        UNIT_ASSERT(google::protobuf::util::MessageDifferencer::ApproximatelyEquals(ref, result));
    }

    Y_UNIT_TEST(MultipleUserDataStatsTest) {
        const TString userDataStats1Yaml = "stratum:\n"
                                          "  strata:\n"
                                          "  - strata:\n"
                                          "      device: desktop\n"
                                          "      country: russia\n"
                                          "      city: moscow\n"
                                          "      has_crypta_i_d: true\n"
                                          "    segment:\n"
                                          "    - segment:\n"
                                          "        keyword: 1\n"
                                          "        i_d: 2\n"
                                          "      count: 1\n"
                                          "    - segment:\n"
                                          "        keyword: 2\n"
                                          "        i_d: 3\n"
                                          "      count: 3\n"
                                          "    age:\n"
                                          "    - age: from_0_to_17\n"
                                          "      count: 2\n"
                                          "    - age: from_18_to_24\n"
                                          "      count: 3\n"
                                          "    gender:\n"
                                          "    - gender: male\n"
                                          "      count: 3\n"
                                          "    - gender: female\n"
                                          "      count: 6\n"
                                          "    income:\n"
                                          "    - income: income_b1\n"
                                          "      count: 4\n"
                                          "    - income: income_b2\n"
                                          "      count: 11\n"
                                          "    count: 50\n";

        const TString userDataStats2Yaml = "stratum:\n"
                                          "  strata:\n"
                                          "  - strata:\n"
                                          "      device: desktop\n"
                                          "      country: russia\n"
                                          "      city: moscow\n"
                                          "      has_crypta_i_d: true\n"
                                          "    segment:\n"
                                          "    - segment:\n"
                                          "        keyword: 1\n"
                                          "        i_d: 2\n"
                                          "      count: 1\n"
                                          "    - segment:\n"
                                          "        keyword: 3\n"
                                          "        i_d: 2\n"
                                          "      count: 7\n"
                                          "    age:\n"
                                          "    - age: from_18_to_24\n"
                                          "      count: 3\n"
                                          "    - age: from_25_to_34\n"
                                          "      count: 1\n"
                                          "    gender:\n"
                                          "    - gender: male\n"
                                          "      count: 1\n"
                                          "    income:\n"
                                          "    - income: income_b2\n"
                                          "      count: 1\n"
                                          "    - income: income_c1\n"
                                          "      count: 1\n"
                                          "    count: 60\n";

        const TString refYaml = "stratum:\n"
                                "  strata:\n"
                                "  - strata:\n"
                                "      device: desktop\n"
                                "      country: russia\n"
                                "      city: moscow\n"
                                "      has_crypta_i_d: true\n"
                                "    segment:\n"
                                "    - segment:\n"
                                "        keyword: 1\n"
                                "        i_d: 2\n"
                                "      count: 2\n"
                                "    - segment:\n"
                                "        keyword: 2\n"
                                "        i_d: 3\n"
                                "      count: 3\n"
                                "    - segment:\n"
                                "        keyword: 3\n"
                                "        i_d: 2\n"
                                "      count: 7\n"
                                "    age:\n"
                                "    - age: from_0_to_17\n"
                                "      count: 2\n"
                                "    - age: from_18_to_24\n"
                                "      count: 6\n"
                                "    - age: from_25_to_34\n"
                                "      count: 1\n"
                                "    gender:\n"
                                "    - gender: male\n"
                                "      count: 4\n"
                                "    - gender: female\n"
                                "      count: 6\n"
                                "    income:\n"
                                "    - income: income_b1\n"
                                "      count: 4\n"
                                "    - income: income_b2\n"
                                "      count: 12\n"
                                "    - income: income_c1\n"
                                "      count: 1\n"
                                "    count: 110\n";

        const auto& userDataStats1 = NCrypta::Yaml2Proto<TUserDataStats>(userDataStats1Yaml);
        const auto& userDataStats2 = NCrypta::Yaml2Proto<TUserDataStats>(userDataStats2Yaml);
        const auto& ref = NCrypta::Yaml2Proto<TUserDataStats>(refYaml);


        TStrataAggregator strataAggregator;
        TUserDataStats result;

        strataAggregator.UpdateWith(userDataStats1.GetStratum());
        strataAggregator.UpdateWith(userDataStats2.GetStratum());
        strataAggregator.MergeInto(result.MutableStratum());

        UNIT_ASSERT(google::protobuf::util::MessageDifferencer::ApproximatelyEquals(ref, result));
    }

    Y_UNIT_TEST(MultipleStratasTest) {
        const TString userDataStatsYaml = "stratum:\n"
                                          "  strata:\n"
                                          "  - strata:\n"
                                          "      device: desktop\n"
                                          "      country: russia\n"
                                          "      city: moscow\n"
                                          "      has_crypta_i_d: false\n"
                                          "    segment:\n"
                                          "    - segment:\n"
                                          "        keyword: 1\n"
                                          "        i_d: 2\n"
                                          "      count: 1\n"
                                          "    age:\n"
                                          "    - age: from_0_to_17\n"
                                          "      count: 2\n"
                                          "    gender:\n"
                                          "    - gender: male\n"
                                          "      count: 3\n"
                                          "    income:\n"
                                          "    - income: income_b1\n"
                                          "      count: 4\n"
                                          "    count: 50\n"
                                          "  - strata:\n"
                                          "      device: desktop\n"
                                          "      country: russia\n"
                                          "      city: moscow\n"
                                          "      has_crypta_i_d: true\n"
                                          "    segment:\n"
                                          "    - segment:\n"
                                          "        keyword: 1\n"
                                          "        i_d: 2\n"
                                          "      count: 2\n"
                                          "    age:\n"
                                          "    - age: from_0_to_17\n"
                                          "      count: 4\n"
                                          "    gender:\n"
                                          "    - gender: male\n"
                                          "      count: 6\n"
                                          "    income:\n"
                                          "    - income: income_b1\n"
                                          "      count: 8\n"
                                          "    count: 100\n";

        const TString refYaml = "stratum:\n"
                                "  strata:\n"
                                "  - strata:\n"
                                "      device: desktop\n"
                                "      country: russia\n"
                                "      city: moscow\n"
                                "      has_crypta_i_d: false\n"
                                "    segment:\n"
                                "    - segment:\n"
                                "        keyword: 1\n"
                                "        i_d: 2\n"
                                "      count: 2\n"
                                "    age:\n"
                                "    - age: from_0_to_17\n"
                                "      count: 4\n"
                                "    gender:\n"
                                "    - gender: male\n"
                                "      count: 6\n"
                                "    income:\n"
                                "    - income: income_b1\n"
                                "      count: 8\n"
                                "    count: 100\n"
                                "  - strata:\n"
                                "      device: desktop\n"
                                "      country: russia\n"
                                "      city: moscow\n"
                                "      has_crypta_i_d: true\n"
                                "    segment:\n"
                                "    - segment:\n"
                                "        keyword: 1\n"
                                "        i_d: 2\n"
                                "      count: 4\n"
                                "    age:\n"
                                "    - age: from_0_to_17\n"
                                "      count: 8\n"
                                "    gender:\n"
                                "    - gender: male\n"
                                "      count: 12\n"
                                "    income:\n"
                                "    - income: income_b1\n"
                                "      count: 16\n"
                                "    count: 200\n";

        const auto& userDataStats = NCrypta::Yaml2Proto<TUserDataStats>(userDataStatsYaml);
        const auto& ref = NCrypta::Yaml2Proto<TUserDataStats>(refYaml);

        TStrataAggregator strataAggregator;
        TUserDataStats result;

        strataAggregator.UpdateWith(userDataStats.GetStratum());
        strataAggregator.UpdateWith(userDataStats.GetStratum());
        strataAggregator.MergeInto(result.MutableStratum());

        Cout << NCrypta::NProtoSerializer::ToJson(result) << Endl;
        UNIT_ASSERT(google::protobuf::util::MessageDifferencer::ApproximatelyEquals(ref, result));
    }
}
