#include <crypta/lab/lib/native/utils.h>

#include <library/cpp/dot_product/dot_product.h>

#include <util/generic/xrange.h>

static const TMap<NLab::ELabIdentifierType, NCrypta::NIdentifiersProto::NIdType::EIdType> LAB_NAME_TO_ID_TYPE = {
    {NLab::LAB_ID_UNKNOWN, NCrypta::NIdentifiersProto::NIdType::DEFAULT},
    {NLab::LAB_ID_YANDEXUID, NCrypta::NIdentifiersProto::NIdType::YANDEXUID},
    {NLab::LAB_ID_ICOOKIE, NCrypta::NIdentifiersProto::NIdType::ICOOKIE},
    {NLab::LAB_ID_IDFA_GAID, NCrypta::NIdentifiersProto::NIdType::IDFA_GAID},
    {NLab::LAB_ID_MM_DEVICE_ID, NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID},
    {NLab::LAB_ID_EMAIL, NCrypta::NIdentifiersProto::NIdType::EMAIL},
    {NLab::LAB_ID_PHONE, NCrypta::NIdentifiersProto::NIdType::PHONE},
    {NLab::LAB_ID_PUID, NCrypta::NIdentifiersProto::NIdType::PUID},
    {NLab::LAB_ID_LOGIN, NCrypta::NIdentifiersProto::NIdType::LOGIN},
    {NLab::LAB_ID_UUID, NCrypta::NIdentifiersProto::NIdType::UUID},
    {NLab::LAB_ID_CRYPTA_ID, NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID}};

TMaybe<NCrypta::NIdentifiersProto::NIdType::EIdType> ConvertLabType(NLab::ELabIdentifierType labType) {
    if (LAB_NAME_TO_ID_TYPE.contains(labType)) {
        return MakeMaybe(LAB_NAME_TO_ID_TYPE.at(labType));
    } else {
        return Nothing();
    }
}

double NLab::Dot(const TVectorType& first, const TVectorType& second) {
    return DotProduct(first.GetData().data(), second.GetData().data(), first.GetData().size());
}

double NLab::ComputeNorm(const TVectorType& vector) {
    return sqrt(Dot(vector, vector));
}

void NLab::Normalize(TVectorType& vector) {
    double norm = ComputeNorm(vector);
    for (auto i : xrange(vector.GetData().size())) {
        Of(vector)[i] /= norm;
    }
}
