#pragma once

#include <util/generic/map.h>
#include <util/generic/maybe.h>

#include <crypta/lib/proto/identifiers/identifiers.pb.h>
#include <crypta/lab/proto/matching.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>

#include <util/generic/hash.h>
#include <util/digest/murmur.h>

TMaybe<NCrypta::NIdentifiersProto::NIdType::EIdType> ConvertLabType(NLab::ELabIdentifierType labType);


class TFilterIdentifier {
public:
    TFilterIdentifier(double probability = 0.3, double maxAccuracy = 1e-3) {
        Init(probability, maxAccuracy);
    }

    void Init(double probability = 0.3, double maxAccuracy = 1e-3) {
        Denom = static_cast<ui64>(1. / maxAccuracy);
        Threshold = static_cast<ui64>(probability * Denom);
    }

    template <typename T>
    bool Filter(const T& identifier) {
        if (!Threshold) {
            return false;
        }
        TString strIdentifier = ToString(identifier);
        auto value = MurmurHash<ui64>(strIdentifier.c_str(), strIdentifier.size(), 0);
        return value % Denom  <= Threshold;
    }
private:
    ui64 Denom;
    ui64 Threshold;
};

namespace NLab {
    double Dot(const TVectorType& first, const TVectorType& second);
    double ComputeNorm(const TVectorType& vector);
    void Normalize(TVectorType& vector);

    template <class T>
    inline float* Of(T& withData) {
        return withData.MutableData()->mutable_data();
    }

}
