from crypta.lib.python.bt.workflow import (
    IndependentTask,
)
from crypta.lib.python.bt.tasks import (
    YQLTaskV1 as YQLTask,
)
from crypta.lib.python.bt.workflow.targets.table import (
    HasAttribute,
)

import library.python.resource as rs
import crypta.lib.python.bt.conf.conf as conf

import datetime
import logging

logger = logging.getLogger(__name__)

MINUTE = 60
HOUR = MINUTE * 60
DAY = HOUR * 24


class PrepareSample(YQLTask, IndependentTask):
    @property
    def _today(self):
        return datetime.date.today().isoformat()

    @property
    def _yesterday(self):
        return (datetime.date.today() - datetime.timedelta(days=1)).isoformat()

    @property
    def _attribute(self):
        return '_day'

    @property
    def destination_emails(self):
        return conf.paths.ids_storage.email.emails_eu

    @property
    def destination_puids(self):
        return conf.paths.ids_storage.puid.puids_eu

    def targets(self):
        yield HasAttribute(
            self.yt,
            self.destination_emails,
            self._attribute,
            self._today,
        )

        yield HasAttribute(
            self.yt,
            self.destination_puids,
            self._attribute,
            self._today,
        )

    @property
    def query(self):
        return rs.find('/crypta/lab/mails_puids_eu.yql').format(
            vertices=conf.paths.graph.vertices_no_multi_profile,
            vertices_by_crypta_id=conf.paths.graph.vertices_by_crypta_id,
            vertices_properties=conf.paths.graph.vertices_properties,
            output_email_table=self.destination_emails,
            output_puid_table=self.destination_puids,
        )

    def run(self, **kwargs):
        super(PrepareSample, self).run(**kwargs)
        self.yt.set_attribute(self.destination_emails, self._attribute, self._today)
        self.yt.set_attribute(self.destination_puids, self._attribute, self._today)
