class YtSpecs(object):
    SMALL_DATA_SIZE_PER_SORT_JOB = {'data_size_per_sort_job': 1024*1024*128}
    SMALL_DATA_SIZE_PER_MAP_JOB = {'data_size_per_map_job': 1024*1024*256}
    VERY_SMALL_DATA_SIZE_PER_MAP_JOB = {'data_size_per_map_job': 1024*1024*8}
    MEDIUM_DATA_SIZE_PER_MAP_JOB = {'data_size_per_map_job': 1024*1024*1024}
    REDUCER_BIG_ROWS = {
        "reduce_job_io": {
            "table_writer": {
                "max_row_weight": 128 * 1024 * 1024
            }
        }

    }
    MAPPER_BIG_ROWS = {
        "mapper_job_io": {
            "table_writer": {
                "max_row_weight": 128 * 1024 * 1024
            }
        }

    }
    MAPPER_HIGH_MEMORY_USAGE = {
        'mapper': {'memory_limit': 1024 * 1024 * 1024 * 8},
    }
    MAPPER_VERY_HIGH_MEMORY_USAGE = {
        'mapper': {'memory_limit': 1024 * 1024 * 1024 * 16},
    }
    REDUCER_HIGH_MEMORY_USAGE = {
        'reducer': {'memory_limit': 1024 * 1024 * 1024 * 8},
        'reduce_combiner': {'memory_limit': 1024 * 1024 * 1024 * 8}
    }
    JOIN_REDUCE_HEAVY_JOBS = {'max_data_size_per_job': 1024*1024*1024*1024*2}
    NO_INTERMEDIATE_COMPRESSION = {'intermediate_compression_codec': 'none'}
    VERY_HIGH_MEMORY_USAGE = {'memory_limit': 1024*1024*1024*16}
    HIGH_MEMORY_USAGE = {'memory_limit': 1024*1024*1024*8}
    ALLOW_BIG_ROWS = {
        "job_io": {
            "table_writer": {
                "max_row_weight": 128 * 1024 * 1024
            }
        }
    }


def _spec(*parts):
    spec = {}
    for part in parts:
        spec.update(part)
    return spec
