PY2_LIBRARY()

OWNER(g:crypta)

PEERDIR(
    contrib/python/cached-property
    crypta/graph/soup/config/python
    crypta/graph/matching/direct/proto
    crypta/graph/soup/config/proto
    crypta/lab/lib/native
    crypta/lab/proto
    crypta/lib/proto/user_data
    crypta/lib/python/audience/client
    crypta/lib/python/bt/commons/dates
    crypta/lib/python/bt/paths
    crypta/lib/python/bt/tasks
    crypta/lib/python/bt/workflow
    crypta/lib/python/bt/yt
    crypta/lib/python/proto
    crypta/lib/python/swagger
    crypta/lib/python/yt/schema_utils
    crypta/lib/python/yt/yt_helpers
    crypta/lookalike/lib/python/utils
    crypta/lookalike/services/user_dssm_applier/py
    crypta/siberia/bin/common/convert_to_user_data_stats/py
    crypta/siberia/bin/common/create_user_set_from_sample_reducer/py
    crypta/siberia/bin/common/describing/mode/python
    crypta/siberia/bin/common/proto
    crypta/siberia/bin/common/sample_stats_getter
    crypta/siberia/bin/common/siberia_client
    crypta/siberia/bin/common/yt_describer/py
    library/python/resource
    library/python/tvmauth
    sandbox/projects/crypta/common/crypta_api
)

PY_SRCS(
    __init__.py
    audience.py
    common.py
    describe.py
    learn.py
    lookalike.py
    match.py
    mixed_userdata.py
    native_operations.pyx
    paths.py
    samples/apps.py
    samples/domains.py
    samples/mails_puids_eu.py
    samples/samples.py
    samples/segments.py
    specs.py
    tables.py
    userdata.py
)

RESOURCE(
    crypta/lib/python/yql_runner/query/aggregation_lib.sql /lib/aggregation_lib.sql
    crypta/lib/python/yql_runner/query/metrica_lib.sql /lib/metrica_lib.sql
    samples/apps.yql /crypta/lab/apps_sample.yql
    samples/domains.yql /crypta/lab/domains_sample.yql
    samples/mails_puids_eu.yql /crypta/lab/mails_puids_eu.yql
    samples/subsamples_info.yql /crypta/lab/subsamples_info.yql
    query/audience.yql /crypta/lab/audience.yql
    query/distinct_dates.yql /crypta/lab/distinct_dates.yql
    query/matching_by_date.yql /crypta/lab/matching_by_date.yql
    query/matching_with_userdata.yql /crypta/lab/matching_with_userdata.yql
    query/mix_userdata.yql /crypta/lab/mix_userdata.yql
    query/store_daily.yql /crypta/lab/store_daily.yql
)

END()

RECURSE(
    crypta_id
    native
    samples
)

RECURSE_FOR_TESTS(
    samples/test
    test
)
