import logging

from crypta.lib.python.swagger import swagger
from crypta.lib.python.worker_utils import task_queue
from crypta.lab.rule_estimator.services.worker.lib import (
    describer_worker,
    stats,
)

logger = logging.getLogger(__name__)


class Describer(task_queue.TaskQueue):
    def __init__(self, cookie_queue, config, metrics, common_labels):
        super(Describer, self).__init__(
            cookie_queue=cookie_queue,
            context=(config, swagger(config.Api.Url, config.Api.Token)),
            worker_count=config.Workers,
            worker_cls=describer_worker.Worker,
            metrics=metrics,
            common_labels=common_labels,
        )
        self.mp_metric_registry.add_aggregation_label(stats.RULE_CONDITION_TYPE)

    def send_to_task_queue(self, task):
        rule_condition_tasks = self.tracker.register(set(task.task.RuleConditionIds), lambda: super(Describer, self).send_to_task_queue(task))

        for rule_condition_task in rule_condition_tasks:
            logger.debug("Putting to task queue: %s", rule_condition_task)
            super(Describer, self).send_to_task_queue(rule_condition_task)
