SELECT
    id,
    id_type
FROM (
{% for table in aggregate_tables + yuid_tables %}
     SELECT
         rand() AS random_key,
         {% if table in aggregate_tables %}
         id,
         id_type
         {% else %}
         CAST(yandexuid AS String) AS id,
         'yandexuid' AS id_type
         {% endif %}
     FROM `{{ table }}`
     {{"UNION ALL" if not loop.last}}
{% endfor %}
)
ORDER BY random_key
LIMIT {{ sample_size }};