import signal

from crypta.lab.rule_estimator.proto import update_pb2
from crypta.lab.rule_estimator.services.worker.lib.describer import Describer
from crypta.lab.rule_estimator.services.worker.lib import stats
from crypta.lib.python.lb_pusher import logbroker
from crypta.lib.python.lb_pusher.reader_config import ReaderConfig
from crypta.lib.python import secret_manager
from crypta.profile.utils.config import (
    config as profile_config,
    secrets,
)
from crypta.lib.python.worker_utils.proto_reader import ProtoReader
from crypta.lib.python.worker_utils.stats_server import StatsServer


def run(config, logger):
    profile_config.CRYPTA_YT_PROXY = config.Yt.Proxy
    profile_config.DEFAULT_POOL = config.Yt.Pool
    profile_config.YT_OPERATION_OWNERS = list(config.YtOperationOwners)

    pq_client = logbroker.PQClient(
        config.Logbroker.Url,
        config.Logbroker.Port,
        tvm_id=config.Tvm.SourceTvmId,
        tvm_secret=config.Tvm.Secret,
    )
    pq_reader = pq_client.get_async_reader(ReaderConfig(topic=config.Topic, client_id=config.Consumer, max_count=1))
    describer = Describer(pq_reader.done_cookies, config, stats.get_metrics(), dict(config.CommonLabels))
    stats_server = StatsServer(config.StatsHost, config.StatsPort, describer.mp_metric_registry)
    reader = ProtoReader(describer.schedule, update_pb2.Update)

    secrets.SECRETS_SINGLETON = secret_manager.SecretManager(
        {},
        secrets_by_name={
            'YT_TOKEN': config.Yt.Token,
            'YQL_TOKEN': config.Yql.Token,
        },
    )

    signal.signal(signal.SIGTERM, lambda *args: pq_reader.stop())
    stats_server.start()

    with describer, pq_client, pq_reader:
        logger.info("Starting loop")
        pq_reader.loop(reader.schedule)
