grammar WordRule;

root
    : expression EOF
    ;

expression
    : '(' expr=expression ')'                      # parenthesesExpr
    | <assoc=right> op=OP_NOT expr=expression      # unaryExpr
    | left=expression op=OP_AND right=expression   # binaryExpr
    | value=EXPORT                                 # lemmaExpr
    | left=expression op=HYPHEN right=expression   # binaryExpr
    | left=expression op=OP_OR right=expression    # binaryExpr
    | value=WORD                                   # lemmaExpr
    ;

OP_NOT
    : 'NOT'
    ;

OP_OR
    : 'OR'
    ;

OP_AND
    : 'AND'
    ;

HYPHEN
    : '-'
    ;

WORD
    : [\p{Alnum}]+
    ;

EXPORT
    : 'export-'[0-9a-f]+
    ;

WS
    : [\p{White_Space}]+ -> skip
    ;
