import mkdocs.plugins
from collections import defaultdict
from crypta.graph.soup.config.python import SOURCE_TYPE, EDGE_TYPE


def source_ordering(x):
    # Put all partners to the end
    if x.Name.startswith('partner'):
        return 'z' + x.Name
    else:
        return x.Name


class MkDocsSoupConfig(mkdocs.plugins.BasePlugin):
    def on_page_markdown(self, markdown, page, config, files):
        edges_by_source = defaultdict(list)
        for et in EDGE_TYPE.values():
            edges_by_source[et.SourceType.Name].append(et)

        result = ''
        source_types = [x for x in sorted(SOURCE_TYPE.values(), key=source_ordering) if x.Type != SOURCE_TYPE.MASKED_TYPE.Type]
        for src in source_types:
            pairs = ', '.join(['{}-{}'.format(x.Id1Type.Name, x.Id2Type.Name) for x in edges_by_source[src.Name]])
            result += '1. **{name}**: {descr} ({pairs})\n'.format(name=src.Name, descr=src.Description, pairs=pairs)

        return markdown.replace('??sources??', result)
