import os
import tarfile
import contextlib

import yatest.common.runtime as runtime


def java_path():
    """
    Get path to java
    :return: absolute path to java
    """

    if not hasattr(java_path, 'jdk_dir'):
        java_path.jdk_dir = runtime.work_path('jdk')
        jdk_tar_path = runtime.work_path('openjdk-17.0.2.tgz')
        with contextlib.closing(tarfile.open(jdk_tar_path)) as tf:
            tf.extractall(java_path.jdk_dir)
    return os.path.join(java_path.jdk_dir, 'bin', 'java')
