CHECK_JAVA_DEPS(yes)

USE_ERROR_PRONE()
JAVAC_FLAGS(
    -Xep:ComputeIfAbsentAmbiguousReference:WARN
    -Xep:ProtoBuilderReturnValueIgnored:WARN
)

LINT(strict)

SET(guava_version 30.0-jre)
SET(gson_version 2.8.6)
SET(jersey_version 2.35)
SET(slf4j_version 1.7.30)
SET(jackson_version 2.9.10)
SET(swagger_version 1.5.18)
SET(junit_version 4.13)
SET(jooq_version 3.13.3)
SET(quartz_version 2.3.2)
SET(hikari_version 3.2.0)
SET(postgresql_version 42.2.14)
SET(logback_version 1.2.3)
SET(retrofit_version 2.9.0)
SET(okhttp_version 4.2.2)
SET(jaxb_version 2.3.0.1)
SET(logstash_version 6.1)
SET(grpc_version 1.30.2)
SET(log4j_version 2.15.0)

DEPENDENCY_MANAGEMENT(
    contrib/java/io/swagger/swagger-core/${swagger_version}
    contrib/java/io/swagger/swagger-annotations/${swagger_version}
    contrib/java/io/swagger/swagger-jaxrs/${swagger_version}

    contrib/java/org/apache/logging/log4j/log4j-api/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-core/${log4j_version}

    contrib/java/org/slf4j/slf4j-api/${slf4j_version}
    contrib/java/org/slf4j/jcl-over-slf4j/${slf4j_version}
    contrib/java/org/slf4j/jul-to-slf4j/${slf4j_version}
    contrib/java/org/slf4j/slf4j-log4j12/${slf4j_version}
    contrib/java/org/slf4j/log4j-over-slf4j/${slf4j_version}

    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${jackson_version}

    contrib/java/org/glassfish/jersey/core/jersey-server/${jersey_version}
    contrib/java/org/glassfish/jersey/core/jersey-common/${jersey_version}
    contrib/java/org/glassfish/jersey/containers/jersey-container-jetty-http/${jersey_version}
    contrib/java/org/glassfish/jersey/media/jersey-media-json-jackson/${jersey_version}
    contrib/java/org/glassfish/jersey/media/jersey-media-multipart/${jersey_version}
    contrib/java/org/glassfish/jersey/inject/jersey-hk2/${jersey_version}
    contrib/java/org/glassfish/jersey/ext/jersey-bean-validation/${jersey_version}

    contrib/java/org/glassfish/jersey/test-framework/jersey-test-framework-core/${jersey_version}
    contrib/java/org/glassfish/jersey/test-framework/providers/jersey-test-framework-provider-inmemory/${jersey_version}

    contrib/java/junit/junit/${junit_version}
    contrib/java/org/mockito/mockito-core/4.3.1

    contrib/java/com/google/guava/guava/${guava_version}
    contrib/java/com/google/code/gson/gson/${gson_version}

    contrib/java/org/quartz-scheduler/quartz/${quartz_version}

    contrib/java/org/jooq/jooq/${jooq_version}
    contrib/java/com/zaxxer/HikariCP/${hikari_version}
    contrib/java/org/postgresql/postgresql/${postgresql_version}

    contrib/java/ch/qos/logback/logback-classic/${logback_version}
    contrib/java/net/logstash/logback/logstash-logback-encoder/${logstash_version}

    contrib/java/com/squareup/retrofit2/retrofit/${retrofit_version}
    contrib/java/com/squareup/retrofit2/converter-jackson/${retrofit_version}
    contrib/java/com/squareup/okhttp3/okhttp/${okhttp_version}

    contrib/java/net/sourceforge/jtds/jtds/1.3.1
    contrib/java/net/sf/jopt-simple/jopt-simple/4.7
    contrib/java/xml-apis/xml-apis/1.3.04
    contrib/java/org/reflections/reflections/0.9.11
    contrib/java/org/flywaydb/flyway-core/6.0.8
    contrib/java/com/amazonaws/aws-java-sdk-s3/1.11.179
    contrib/java/org/apache/httpcomponents/httpclient/4.5.2
    contrib/java/org/apache/commons/commons-lang3/3.12.0
    contrib/java/org/freemarker/freemarker/2.3.28
    contrib/java/jakarta/servlet/jakarta.servlet-api/4.0.3

    contrib/java/io/grpc/grpc-netty-shaded/${grpc_version}
    contrib/java/io/grpc/grpc-protobuf/${grpc_version}
    contrib/java/io/grpc/grpc-stub/${grpc_version}

    contrib/java/com/sun/xml/bind/jaxb-core/${jaxb_version}
    contrib/java/com/sun/xml/bind/jaxb-impl/${jaxb_version}
)

EXCLUDE(
    contrib/java/aopalliance/aopalliance
    contrib/java/com/google/code/findbugs/annotations
    contrib/java/com/google/protobuf/protobuf-javalite
    contrib/java/com/sun/activation/javax.activation
    contrib/java/com/zaxxer/HikariCP-java6
    contrib/java/com/zaxxer/HikariCP-java7
    contrib/java/commons-logging/commons-logging
    contrib/java/jakarta/el/jakarta.el-api
    contrib/java/javax/servlet/javax.servlet-api
    contrib/java/javax/activation/activation
    contrib/java/javax/activation/javax.activation-api
    contrib/java/javax/annotation/javax.annotation-api
    contrib/java/javax/inject/javax.inject
    contrib/java/javax/mail/mail
    contrib/java/javax/validation/validation-api
    contrib/java/javax/ws/rs/javax.ws.rs-api
    contrib/java/javax/ws/rs/jsr311-api
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/jaxen/jaxen
    contrib/java/log4j/apache-log4j-extras
    contrib/java/log4j/log4j
    contrib/java/org/kohsuke/jetbrains/annotations
    contrib/java/xmlpull/xmlpull
    quality/personalization/batch/user_history/proto
    iceberg/misc-spring
)

UBERJAR_PATH_EXCLUDE_PREFIX(
# https://stackoverflow.com/questions/34855649/invalid-signature-file-digest-for-manifest-main-attributes-exception-while-tryin
    META-INF/SAXONICA.RSA
    META-INF/SAXONICA.SF

# conflicting names during jar unpackage "jar xf graph-matching.jar"
# caused by mix of UBERJAR and OSX file system case-insensitive behavior
    license
    LICENSE
    META-INF/LICENSE
    META-INF/license
)
