package ru.yandex.crypta.common;

import java.util.Map;
import java.util.Objects;

public class Language {

    private static final String RU_CODE = "RU";
    private static final String EN_CODE = "EN";

    public static final Language RU = new Language(RU_CODE);
    public static final Language EN = new Language(EN_CODE);
    public static final Map<String, Language> ALL_SUPPORTED = Map.of(
            RU_CODE, RU,
            EN_CODE, EN
    );

    private final String value;

    public Language(String value) {
        this.value = value.toUpperCase();
    }

    public static Language ru() {
        return RU;
    }

    public static Language en() {
        return EN;
    }

    public static Language orDefault(Language language) {
        if (language != null) {
            return language;
        } else {
            return ru();
        }
    }

    public boolean isRu() {
        return value.equals(RU_CODE);
    }

    public boolean isEn() {
        return value.equals(EN_CODE);
    }

    @Override
    public String toString() {
        return value.toLowerCase();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Language language)) {
            return false;
        }
        return value.equals(language.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }
}
