package ru.yandex.crypta.common.data;

import java.util.ArrayList;
import java.util.List;

import org.jooq.Configuration;
import org.jooq.impl.DefaultDSLContext;

public class EnhancedDSLContext extends DefaultDSLContext {

    public EnhancedDSLContext(Configuration configuration) {
        super(configuration);
    }

    public interface TransactionBody<T> {
        T perform(Configuration configuration);
    }

    public <T> T withTransaction(TransactionBody<T> body) {
        List<T> results = new ArrayList<>(1);
        transaction(configuration -> {
            T result = body.perform(configuration);
            results.add(result);
        });
        return results.get(0);
    }
}
