package ru.yandex.crypta.common.data;

import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.impl.DSL;

public abstract class GenericTable<T> {

    protected final DSLContext dsl;
    protected final Class<T> theClass;

    protected GenericTable(Configuration configuration, Class<T> theClass) {
        RegistrableRecordMapperProvider provider = RegistrableRecordMapperProvider.INSTANCE;
        provider.add(theClass, this::read);
        this.dsl = DSL.using(configuration.derive(provider));
        this.dsl.settings().setRenderFormatted(true);
        this.theClass = theClass;
    }

    protected abstract T read(Record record);

    public Class<T> getEntryClass() {
        return theClass;
    }

    public abstract Select selectQuery();

}
