package ru.yandex.crypta.common.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordType;
import org.jooq.impl.DefaultRecordMapper;

public enum RegistrableRecordMapperProvider implements RecordMapperProvider {

    INSTANCE;

    private final Map<Class, Function<Record, Object>> mappers = new HashMap<>();

    public void add(Class theClass, Function<Record, Object> mapper) {
        mappers.put(theClass, mapper);
    }

    @Override
    @SuppressWarnings("unchecked")
    public <R extends Record, E> RecordMapper<R, E> provide(
            RecordType<R> recordType, Class<? extends E> type
    ) {
        Function<Record, Object> mapper = mappers.get(type);
        if (mapper != null) {
            return record -> (E) mapper.apply(record);
        } else {
            return new DefaultRecordMapper<>(recordType, type);
        }
    }
}
