package ru.yandex.crypta.common.data;

import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.impl.DSL;

public class TransactionLock {

    private static final String TRY_ADVISORY_XACT_LOCK = "pg_try_advisory_xact_lock";
    private static final Field<Boolean> ACQUIRED = DSL.field(TRY_ADVISORY_XACT_LOCK, Boolean.class);

    public static boolean acquire(Configuration transaction, int id) {
        Record1<Boolean> result = DSL.using(transaction)
                .select(ACQUIRED)
                .from(TRY_ADVISORY_XACT_LOCK + String.format("(%d)", id))
                .fetchOne();
        return result.value1();
    }

}
