package ru.yandex.crypta.common.exception;

public class Exceptions {

    private Exceptions() {
    }

    public static RuntimeException unchecked(Throwable e) {
        return new RuntimeException(e);
    }

    public static UnavailableException unavailable() {
        return new UnavailableException();
    }

    public static IllegalOperationException illegal(String message) {
        return new IllegalOperationException(message);
    }

    public static NotAuthenticatedException notAuthenticated(String message) {
        return new NotAuthenticatedException(message);
    }

    public static OutdatedAuthenticationException outdatedAuthentication(String authenticationUrl) {
        return new OutdatedAuthenticationException(authenticationUrl);
    }

    public static BadAuthenticationException badAuthentication(String authenticationUrl) {
        return new BadAuthenticationException(authenticationUrl);
    }

    public static WrongRequestException wrongRequestException(String message, String code) {
        return new WrongRequestException(message, code);
    }

    public static TooManyRequestsException tooManyRequestsException() {
        return new TooManyRequestsException();
    }

    public static ForbiddenException forbidden(String message, String code) {
        return new ForbiddenException(message, code);
    }

    public static NotFoundException notFound(String message) {
        return new NotFoundException(message);
    }

    public static NotFoundException notFound() {
        return notFound("Not found");
    }

    public static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException();
    }

    public static RuntimeException internal(String reason) {
        return new RuntimeException(reason);
    }
}
