package ru.yandex.crypta.clients.audience;

import com.fasterxml.jackson.databind.JsonNode;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface AudienceApi {

    @GET("v1/management/segments/")
    Call<JsonNode> listSegments();

    @GET("v1/management/segment/{segmentId}/grants/")
    Call<AudienceListGrantsResponse> getGrants(
            @Path("segmentId") String segmentId
    );

    @PUT("v1/management/segment/{segmentId}/grant/")
    Call<AudienceCreateGrantResponse> createGrant(
            @Path("segmentId") String segmentId,
            @Body RequestBody grant
    );

    @DELETE("v1/management/segment/{segmentId}/grant/")
    Call<AudienceDeleteResponse> deleteGrant(
            @Path("segmentId") String segmentId,
            @Query("user_login") String userLogin
    );

    @DELETE("v1/management/segment/{segmentId}/")
    Call<AudienceDeleteResponse> deleteSegment(
            @Path("segmentId") String segmentId
    );

    @PUT("v1/management/segment/{segmentId}")
    Call<JsonNode> updateSegment(
            @Path("segmentId") String segmentId,
            @Body RequestBody name
    );

    @Multipart
    @POST("v1/management/client/segments/upload_file/")
    Call<JsonNode> uploadSegmentFile(
            @Query("ulogin") String login,
            @Part MultipartBody.Part file
    );

    @POST("/v1/management/client/segment/{segmentId}/confirm/")
    Call<JsonNode> confirmSegment(
            @Path("segmentId") int segmentId,
            @Body RequestBody segmentParameters,
            @Query("ulogin") String login,
            @Query("check_size") boolean checkSize
    );
}
